/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.traceroute;

import ibm.nways.jdm.common.Counter;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.snmp.SnmpAPI;
import ibm.nways.jdm.snmp.SnmpPDU;
import ibm.nways.jdm.snmp.SnmpSession;
import ibm.nways.jdm.snmp.SnmpSocketException;
import ibm.nways.jdm.snmp.SnmpUnknownHostException;
import ibm.nways.jdm.snmp.SnmpVarBind;
import ibm.nways.jdm.traceroute.RemotePing;
import ibm.nways.jdm.traceroute.RemotePingException;
import ibm.nways.jdm.traceroute.Util;
import java.io.Serializable;
import java.util.ResourceBundle;

public class RemotePingCisco
extends RemotePing {
    private static final String CISCO_REMOTE_PING_OID = "1.3.6.1.4.1.9.9.16.1.1.1";
    private static ResourceBundle strings = ResourceBundle.getBundle((RemotePing.class$ibm$nways$jdm$traceroute$TraceRouteResources != null ? RemotePing.class$ibm$nways$jdm$traceroute$TraceRouteResources : (RemotePing.class$ibm$nways$jdm$traceroute$TraceRouteResources = RemotePing.class$("ibm.nways.jdm.traceroute.TraceRouteResources"))).getName());
    private SnmpSession session;
    private String rowInstance;
    private static final boolean debug = false;

    public RemotePingCisco(IPAddress iPAddress, String string, String string2) {
        super(iPAddress, string, strings.getString("RemotePingCisco"), string2);
        this.pingSupported = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int remotePing(IPAddress iPAddress, int n, int n2, int n3) throws RemotePingException {
        int n4;
        try {
            try {
                this.rowInstance = Integer.toString((int)(Math.random() * 2.147483647E9));
                String string = Util.getCommunityName(this.ipAddress, this.communityName);
                String string2 = Util.getWriteCommunityName(this.ipAddress, this.communityName);
                SnmpAPI.initialize();
                this.session = SnmpSession.open((String)this.ipAddress.toString(), (String)string, (String)string2);
                this.set("1.3.6.1.4.1.9.9.16.1.1.1.16." + this.rowInstance, new Integer(6));
                this.setPingConfig(this.rowInstance, iPAddress, n, n2, n3);
                this.waitUntilFinished(this.rowInstance, n * n3);
                int n5 = this.get("1.3.6.1.4.1.9.9.16.1.1.1.10." + this.rowInstance);
                if (n5 == 0) {
                    throw new RemotePingException(5, "Ping request(s) timed out");
                }
                int n6 = this.get("1.3.6.1.4.1.9.9.16.1.1.1.12." + this.rowInstance);
                this.set("1.3.6.1.4.1.9.9.16.1.1.1.16." + this.rowInstance, new Integer(6));
                n4 = n6;
                Object var7_12 = null;
                if (this.session == null) return n4;
            }
            catch (RemotePingException remotePingException) {
                throw remotePingException;
            }
            catch (SnmpSocketException snmpSocketException) {
                throw new RemotePingException(6, "SnmpSocketException thrown by SnmpAPI.Initialize()");
            }
            catch (SnmpUnknownHostException snmpUnknownHostException) {
                throw new RemotePingException(6, "SnmpUnknownHostException thrown by SnmpSession.open()");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RemotePingException(6, "Exception " + exception);
            }
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            if (this.session == null) throw throwable;
            this.session.close();
            throw throwable;
        }
        this.session.close();
        return n4;
    }

    protected void setPingConfig(String string, IPAddress iPAddress, int n, int n2, int n3) throws RemotePingException {
        SnmpPDU snmpPDU = this.session.makePDU();
        snmpPDU.operation = 3;
        snmpPDU.addVarBind("1.3.6.1.4.1.9.9.16.1.1.1.2." + string, (Serializable)new Integer(1));
        snmpPDU.addVarBind("1.3.6.1.4.1.9.9.16.1.1.1.3." + string, (Serializable)new OctetString(iPAddress.getBytes()));
        snmpPDU.addVarBind("1.3.6.1.4.1.9.9.16.1.1.1.4." + string, (Serializable)new Integer(n));
        snmpPDU.addVarBind("1.3.6.1.4.1.9.9.16.1.1.1.5." + string, (Serializable)new Integer(n2));
        snmpPDU.addVarBind("1.3.6.1.4.1.9.9.16.1.1.1.6." + string, (Serializable)new Integer(n3 * 1000));
        snmpPDU.addVarBind("1.3.6.1.4.1.9.9.16.1.1.1.16." + string, (Serializable)new Integer(4));
        SnmpPDU snmpPDU2 = this.session.send(snmpPDU);
        if (snmpPDU2.errorStatus == 0) {
            return;
        }
        switch (snmpPDU2.errorIndex) {
            case 3: {
                throw new RemotePingException(4, "Invalid attempts: " + n);
            }
            case 4: {
                throw new RemotePingException(2, "Invalid packet size: " + n2);
            }
            case 5: {
                throw new RemotePingException(3, "Invalid timeout: " + n3 + " seconds.");
            }
        }
        throw new RemotePingException(6);
    }

    protected void checkResponse(SnmpPDU snmpPDU) throws RemotePingException {
        if (snmpPDU.errorStatus != 0) {
            throw new RemotePingException(1, snmpPDU.getErrorStatusString());
        }
    }

    protected void set(String string, Serializable serializable) throws RemotePingException {
        SnmpPDU snmpPDU = this.session.makePDU();
        snmpPDU.operation = 3;
        snmpPDU.addVarBind(string, serializable);
        this.checkResponse(this.session.send(snmpPDU));
    }

    protected int get(String string) throws RemotePingException {
        SnmpPDU snmpPDU = this.session.makePDU();
        snmpPDU.operation = 0;
        snmpPDU.addVarBind(string);
        SnmpPDU snmpPDU2 = this.session.send(snmpPDU);
        this.checkResponse(snmpPDU2);
        SnmpVarBind snmpVarBind = snmpPDU2.varBindAt(0);
        Serializable serializable = snmpVarBind.getVar();
        if (serializable instanceof Integer) {
            return (Integer)serializable;
        }
        if (serializable instanceof Counter) {
            return (int)((Counter)serializable).getValue();
        }
        throw new RemotePingException(6, "Error in RemotePingCisco.get().  Value was neither Integer nor Counter");
    }

    protected void waitUntilFinished(String string, int n) throws RemotePingException {
        int n2;
        long l = System.currentTimeMillis() + (long)(n * 1000);
        while ((n2 = this.get("1.3.6.1.4.1.9.9.16.1.1.1.14." + string)) != 1) {
            if (System.currentTimeMillis() > l) {
                throw new RemotePingException(1, "Timeout waiting for ping request(s) to finish.");
            }
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

